/**
* \file: utils.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author:  Veeraiyan Chidambaram /RBEI/ECF3/ veeraiyan.chidambaram@in.bosch.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_UTILS_H
#define CARPLAY_UTILS_H

#include <iostream>
#include <string>
#include <list>
#include <vector>
#include <map>

#include "AirPlayHeaders.h"

namespace adit { namespace carplay
{
    CFLBooleanRef CFBooleanCreateFromInt(uint64_t inBoolean);
    CFNumberRef CFNumberCreateFromStdInt(uint64_t inInt);
    CFStringRef CFStringCreateFromStdString(const std::string& inString);
    CFMutableArrayRef CFArrayCreateMutableFromStdList(const std::list<std::string>& inList);

    enum CFFromStdType
    {
        CFFromStdType_Number,
        CFFromStdType_String
    };
    struct CFFromStdPair { const char* std; CFLStringRef cf; CFFromStdType type; };
    CFMutableDictionaryRef CFDictionaryFromStdMap(const std::map<std::string, std::string>& inMap,
            const CFFromStdPair* inPairs, uint32_t inNum, const std::string& inLog);

    std::vector<std::string> SplitString(const std::string& inValue, const char inSeparators[]);
    std::string TrimString(const std::string& inValue);
    std::map<std::string, std::string> ParseMap(const std::string& inValue,
            bool inLowerCase, const std::string& inLog);
    uint64_t GetCurrentTimeNano();

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_UTILS_H */
